package com.vf106.tools.activity;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.vf106.tools.R;
import com.vf106.tools.utils.Constants;
import com.vf106.tools.utils.WarningUtils;

/**
 * @author syb
 * @description：alarm
 * @date : 2024/3/7 15:27
 */
public class WarnActivity extends AppCompatActivity implements View.OnClickListener {

    private LinearLayout llRight;
    private LinearLayout llWrong;

    private int position;
    private int state;
    private String name;

    private boolean startReadState = true;
    private TextView tv;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_warn);
        initView();
        setListener();

        new Thread(() -> {
            while (startReadState) {
                try {
                    Thread.sleep(200);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                String value101 = WarningUtils.readGPIO101Value();
                String value100 = WarningUtils.readGPIO100Value();

                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        tv.setText("value101: " + value101 + ", value100: " + value100);
                    }
                });
                Log.i("startReadState", "value101: " + value101 + ", value100: " + value100);
            }
        }).start();
    }

    private void initView() {
        llRight = findViewById(R.id.ll_right);
        llWrong = findViewById(R.id.ll_wrong);
        tv = findViewById(R.id.tv);

        Intent intent = getIntent();
        position = intent.getIntExtra("position", 0);
        name = intent.getStringExtra("name");
        state = intent.getIntExtra("state", 0);
    }

    private void setListener() {

        llRight.setOnClickListener(this);
        llWrong.setOnClickListener(this);
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.ll_right:
                state = 1;
                setIntentData();
                break;
            case R.id.ll_wrong:
                state = 2;
                setIntentData();
                break;
        }
    }

    public void setIntentData() {
        Intent intent = new Intent();
        intent.putExtra("name", name);
        intent.putExtra("state", state);
        intent.putExtra("position", position);
        setResult(Constants.resultCode, intent);
        finish();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();

        startReadState = false;
    }
}
